/* --------- LabWindows Generated Code:   Thu Mar 09 11:23:01 1995 --------- */

#include "C:\LW\INCLUDE\lwsystem.h"
#include "C:\LW\INCLUDE\gpib.h"
#include "C:\LW\INCLUDE\formatio.h"

/*                        ͸                  */
/*                                                */
/*        ͻ   ͻ        ͻ ͸            Ŀ   Ŀ */
/*                             ͼ ͻ                  */
/* ; ; ͼ        ; ͼ  ;          */
/* LabTest 2.0 instrument file */
/* Rohde & Schwarz Signal Generator SMH */
/* July 1991 */

#include "rssmh.h"

/* * */
void smh_set_rf (dev, rf, rfunit)
int dev;
double rf;
int rfunit;
{
    int dy;
    
    switch (rfunit)  {
    case 0:
        dy = Fmt (smh_cmd, "RF %fHZ", rf);
        break;
    case 1:
        dy = Fmt (smh_cmd, "RF %fKHZ", rf);
        break;
    case 2:
        dy = Fmt (smh_cmd, "RF %fMHZ", rf);
        break;
    case 3:
        dy = Fmt (smh_cmd, "RF %fGHZ", rf);
        break;
    default:
        smh_err =  -2;
        return;
        break;
    }
    if (smh_write_data (dev, smh_cmd) != 0)  
        return;
    if (!smh_do_opc)  
        return;
    smh_op_complete (dev, &dy);
}

/* * */
void smh_set_rf_level (dev, rflvl, rflvlun, rfb)
int dev;
double rflvl;
int rflvlun;
int rfb;
{
    int dy;
    
    switch (rfb)  {
    case 0:
        dy = Fmt (smh_cmd, "LEV:OFF");
        break;
    case 1:
        dy = Fmt (smh_cmd, "LEV %f", rflvl);
        break;
    case 2:
        dy = Fmt (smh_cmd, "LEV:EMF %f", rflvl);
        break;
    default:
        smh_err =  -4;
        return;
        break;
    }
    if (rfb != 0)  
        switch (rflvlun)  {
        case 0:
            if (rfb == 1)  
                dy = Fmt (smh_cmd, "%sDBM", smh_cmd);
            else  
                dy = Fmt (smh_cmd, "LEV %fDBM", rflvl);
            break;
        case 1:
            dy = Fmt (smh_cmd, "%sDBUV", smh_cmd);
            break;
        case 2:
            dy = Fmt (smh_cmd, "%sMV", smh_cmd);
            break;
        case 3:
            dy = Fmt (smh_cmd, "%sUV", smh_cmd);
            break;
        default:
            smh_err =  -3;
            return;
            break;
        }
    if (smh_write_data (dev, smh_cmd) != 0)  
        return;
    if (!smh_do_opc)  
        return;
    smh_op_complete (dev, &dy);
}

/* * */
void smh_set_af (dev, af, afunit)
int dev;
double af;
int afunit;
{
    int dy;
    
    switch (afunit)  {
    case 0:
        dy = Fmt (smh_cmd, "AF %fHZ", af);
        break;
    case 1:
        dy = Fmt (smh_cmd, "AF %fKHZ", af);
        break;
    default:
        smh_err =  -5;
        return;
        break;
    }
    if (smh_write_data (dev, smh_cmd) != 0)  
        return;
    if (!smh_do_opc)  
        return;
    smh_op_complete (dev, &dy);
}

/* * */
void smh_set_af_level (dev, aflev, afb)
int dev;
int aflev;
int afb;
{
    int dy;
    
    switch (afb)  {
    case 0:
        dy = Fmt (smh_cmd, "AF:OFF;SP6");
        break;
    case 1:
        dy = Fmt (smh_cmd, "LEV:AF %iMV;AF:ON", aflev);
        break;
    default:
        smh_err =  -6;
        return;
        break;
    }
    if (smh_write_data (dev, smh_cmd) != 0)  
        return;
    if (!smh_do_opc)  
        return;
    smh_op_complete (dev, &dy);
}

/* * */
void smh_set_freq_level (dev, rf, rfun, rflev, rflun, rfb, af, afun, aflev, afb)
int dev;
double rf;
int rfun;
double rflev;
int rflun;
int rfb;
double af;
int afun;
int aflev;
int afb;
{
    int dy;
    
    smh_set_rf (dev, rf, rfun);
    if (smh_err != 0)  
        return;
    smh_op_complete (dev, &dy);
    if (smh_err != 0)  
        return;
    smh_set_af (dev, af, afun);
    if (smh_err != 0)  
        return;
    smh_op_complete (dev, &dy);
    if (smh_err != 0)  
        return;
    smh_set_af_level (dev, aflev, afb);
    if (smh_err != 0)  
        return;
    smh_op_complete (dev, &dy);
    if (smh_err != 0)  
        return;
    smh_set_rf_level (dev, rflev, rflun, rfb);
    if (smh_err != 0)  
        return;
    smh_op_complete (dev, &dy);
}

/* * */
void smh_set_freq_level_offset (dev, loffs, roffs, rfunit)
int dev;
double loffs;
double roffs;
int rfunit;
{
    int dy;
    
    dy = Fmt (smh_cmd, "LEV:OFFS %fDB", loffs);
    dy = Fmt (smh_cmd, "%s;RF:OFFS %f", smh_cmd, roffs);
    switch (rfunit)  {
    case 0:
        dy = Fmt (smh_cmd, "%s<%sHZ", smh_cmd);
        break;
    case 1:
        dy = Fmt (smh_cmd, "%s<%sKHZ", smh_cmd);
        break;
    case 2:
        dy = Fmt (smh_cmd, "%s<%sMHZ", smh_cmd);
        break;
    default:
        smh_err =  -7;
        return;
        break;
    }
    if (smh_write_data (dev, smh_cmd) != 0)  
        return;
    if (!smh_do_opc)  
        return;
    smh_op_complete (dev, &dy);
}

/* * */
void smh_set_modulation (dev, fp, ap, phm, fm, am)
int dev;
int fp;
int ap;
double phm;
double fm;
double am;
{
    int dy;
    
    if (fp < 8)  
        dy = Fmt (smh_cmd, "FM %fKHZ", fm);
    else  
        dy = Fmt (smh_cmd, "PHM %fRAD", phm);
    switch (fp)  {
    case 0:
        dy = Fmt (smh_cmd, "%s;FM:OFF;PHM OFF", smh_cmd);
        break;
    case 1:
        dy = Fmt (smh_cmd, "%s;FM:INT", smh_cmd);
        break;
    case 2:
        dy = Fmt (smh_cmd, "%s;FM:EXT:AC", smh_cmd);
        break;
    case 3:
        dy = Fmt (smh_cmd, "%s;FM:EXT:DC", smh_cmd);
        break;
    case 4:
        dy = Fmt (smh_cmd, "%s;FM:DUAL:AC", smh_cmd);
        break;
    case 5:
        dy = Fmt (smh_cmd, "%s;FM:DUAL:DC", smh_cmd);
        break;
    case 6:
        dy = Fmt (smh_cmd, "%s;FM:FSK:AC", smh_cmd);
        break;
    case 7:
        dy = Fmt (smh_cmd, "%s;FM:FSK:DC", smh_cmd);
        break;
    case 8:
        dy = Fmt (smh_cmd, "%s;PHM:INT", smh_cmd);
        break;
    case 9:
        dy = Fmt (smh_cmd, "%s;PHM:EXT", smh_cmd);
        break;
    case 10:
        dy = Fmt (smh_cmd, "%s;PHM:DUAL", smh_cmd);
        break;
    default:
        smh_err =  -8;
        return;
        break;
    }
    if (ap != 0 && ap != 6)  
        dy = Fmt (smh_cmd, "%s;AM %fPCT", smh_cmd, am);
    switch (ap)  {
    case 0:
        dy = Fmt (smh_cmd, "%s;AM:OFF", smh_cmd);
        break;
    case 1:
        dy = Fmt (smh_cmd, "%s;AM:INT", smh_cmd);
        break;
    case 2:
        dy = Fmt (smh_cmd, "%s;AM:EXT:AC", smh_cmd);
        break;
    case 3:
        dy = Fmt (smh_cmd, "%s;AM:EXT:DC", smh_cmd);
        break;
    case 4:
        dy = Fmt (smh_cmd, "%s;AM:DUAL:AC", smh_cmd);
        break;
    case 5:
        dy = Fmt (smh_cmd, "%s;AM:DUAL:DC", smh_cmd);
        break;
    case 6:
        dy = Fmt (smh_cmd, "%s;AM:PULSE", smh_cmd);
        break;
    default:
        smh_err =  -9;
        return;
        break;
    }
    if (smh_write_data (dev, smh_cmd) != 0)  
        return;
    smh_op_complete (dev, &dy);
}

/* * */
void smh_special_setting (dev, rfb, lcb, nonintb)
int dev;
int rfb;
int lcb;
int nonintb;
{
    int dy;
    
    switch (rfb)  {
    case 0:
        dy = Fmt (smh_cmd, "REF:EXT");
        break;
    case 1:
        dy = Fmt (smh_cmd, "REF:INT");
        break;
    default:
        smh_err =  -10;
        return;
        break;
    }
    switch (lcb)  {
    case 0:
        dy = Fmt (smh_cmd, "%s;ALC:FIX", smh_cmd);
        break;
    case 1:
        dy = Fmt (smh_cmd, "%s;ALC:NORMAL", smh_cmd);
        break;
    default:
        smh_err =  -11;
        return;
        break;
    }
    switch (nonintb)  {
    case 0:
        dy = Fmt (smh_cmd, "%s;ATTEN:NORMAL", smh_cmd);
        break;
    case 1:
        dy = Fmt (smh_cmd, "%s;ATTEN:FIX", smh_cmd);
        break;
    default:
        smh_err =  -12;
        return;
        break;
    }
    if (smh_write_data (dev, smh_cmd) != 0)  
        return;
    if (!smh_do_opc)  
        return;
    smh_op_complete (dev, &dy);
}

/* * */
void smh_set_rf_sweep (dev, md, tim, endf, stsiz, startf, stun, endfun, startfun)
int dev;
int md;
double tim;
double endf;
double stsiz;
double startf;
int stun;
int endfun;
int startfun;
{
    int dy;
    
    switch (stun)  {
    case 0:
        dy = Fmt (smh_cmd, "SWP:MODE:RF:LIN;RF:STEP %fHZ", stsiz);
        break;
    case 1:
        dy = Fmt (smh_cmd, "SWP:MODE:RF:LIN;RF:STEP %fKHZ", stsiz);
        break;
    case 2:
        dy = Fmt (smh_cmd, "SWP:MODE:RF:LIN;RF:STEP %fMHZ", stsiz);
        break;
    case 3:
        dy = Fmt (smh_cmd, "SWP:MODE:RF:LIN;RF:STEP %fGHZ", stsiz);
        break;
    case 4:
        dy = Fmt (smh_cmd, "SWP:MODE:RF:LOG;RF:LOG_STEP %fPCT", stsiz);
        break;
    default:
        smh_err =  -13;
        return;
        break;
    }
    dy = Fmt (smh_cmd, "%s;TIME:RF_SWP %fMS", smh_cmd, tim);
    if (smh_write_data (dev, smh_cmd) != 0)  
        return;
    smh_op_complete (dev, &dy);
    if (smh_err != 0)  
        return;
    switch (endfun)  {
    case 0:
        dy = Fmt (smh_cmd, "RF:STOP %fHZ", endf);
        break;
    case 1:
        dy = Fmt (smh_cmd, "RF:STOP %fKHZ", endf);
        break;
    case 2:
        dy = Fmt (smh_cmd, "RF:STOP %fMHZ", endf);
        break;
    case 3:
        dy = Fmt (smh_cmd, "RF:STOP %fGHZ", endf);
        break;
    default:
        smh_err =  -14;
        return;
        break;
    }
    switch (startfun)  {
    case 0:
        dy = Fmt (smh_cmd, "%s;RF:START %fHZ", smh_cmd, startf);
        break;
    case 1:
        dy = Fmt (smh_cmd, "%s;RF:START %fKHZ", smh_cmd, startf);
        break;
    case 2:
        dy = Fmt (smh_cmd, "%s;RF:START %fMHZ", smh_cmd, startf);
        break;
    case 3:
        dy = Fmt (smh_cmd, "%s;RF:START %fGHZ", smh_cmd, startf);
        break;
    default:
        smh_err =  -15;
        return;
        break;
    }
    switch (md)  {
    case 0:
        dy = Fmt (smh_cmd, "%s;SWP:AUTO", smh_cmd);
        break;
    case 1:
        dy = Fmt (smh_cmd, "%s;SWP:SINGLE", smh_cmd);
        break;
    case 2:
        dy = Fmt (smh_cmd, "%s;SWP:MANUAL", smh_cmd);
        break;
    case 3:
        dy = Fmt (smh_cmd, "%s;SWP:RESET", smh_cmd);
        break;
    case 4:
        dy = Fmt (smh_cmd, "%s;SWP:OFF", smh_cmd);
        break;
    default:
        smh_err =  -16;
        return;
        break;
    }
    if (smh_write_data (dev, smh_cmd) != 0)  
        return;
    smh_op_complete (dev, &dy);
}

/* * */
void smh_set_af_sweep (dev, md, tim, endf, stsiz, startf, stun, endfun, startfun)
int dev;
int md;
double tim;
double endf;
double stsiz;
double startf;
int stun;
int endfun;
int startfun;
{
    int dy;
    
    if (md != 4)  {
        switch (stun)  {
        case 0:
            dy = Fmt (smh_cmd, "SWP:MODE:AF:LIN;AF:STEP %fHZ", stsiz);
            break;
        case 1:
            dy = Fmt (smh_cmd, "SWP:MODE:AF:LIN;AF:STEP %fKHZ", stsiz);
            break;
        case 2:
            dy = Fmt (smh_cmd, "SWP:MODE:AF:LOG;AF:LOG_STEP %fPCT", stsiz);
            break;
        default:
            smh_err =  -17;
            return;
            break;
        }
        dy = Fmt (smh_cmd, "%s;TIME:AF_SWP %fMS", smh_cmd, tim);
        if (smh_write_data (dev, smh_cmd) != 0)  
            return;
        smh_op_complete (dev, &dy);
        if (smh_err != 0)  
            return;
        switch (endfun)  {
        case 0:
            dy = Fmt (smh_cmd, "AF:STOP %fHZ", endf);
            break;
        case 1:
            dy = Fmt (smh_cmd, "AF:STOP %fKHZ", endf);
            break;
        default:
            smh_err =  -18;
            return;
            break;
        }
        switch (startfun)  {
        case 0:
            dy = Fmt (smh_cmd, "%s;AF:START %fHZ", smh_cmd, startf);
            break;
        case 1:
            dy = Fmt (smh_cmd, "%s;AF:START %fKHZ", smh_cmd, startf);
            break;
        default:
            smh_err =  -19;
            return;
            break;
        }
    }
    switch (md)  {
    case 0:
        dy = Fmt (smh_cmd, "%s;SWP:AUTO", smh_cmd);
        break;
    case 1:
        dy = Fmt (smh_cmd, "%s;SWP:SINGLE", smh_cmd);
        break;
    case 2:
        dy = Fmt (smh_cmd, "%s;SWP:MANUAL", smh_cmd);
        break;
    case 3:
        dy = Fmt (smh_cmd, "%s;SWP:RESET", smh_cmd);
        break;
    case 4:
        dy = Fmt (smh_cmd, "SWP:OFF;SP10");
        break;
    default:
        smh_err =  -20;
        return;
        break;
    }
    if (smh_write_data (dev, smh_cmd) != 0)  
        return;
    smh_op_complete (dev, &dy);
}

/* * */
void smh_set_freq_level_step (dev, rfstep, rfun, rflev, afstep, aun, aflev)
int dev;
double rfstep;
int rfun;
double rflev;
double afstep;
int aun;
int aflev;
{
    int dy;
    
    switch (aun)  {
    case 0:
        dy = Fmt (smh_cmd, "AF:VAR %fHZ", afstep);
        break;
    case 1:
        dy = Fmt (smh_cmd, "AF:VAR %fKHZ", afstep);
        break;
    default:
        smh_err =  -21;
        return;
        break;
    }
    dy = Fmt (smh_cmd, "%s;LEV:AF:VAR %iMV", smh_cmd, aflev);
    switch (rfun)  {
    case 0:
        dy = Fmt (smh_cmd, "%s;RF:VAR %fHZ", smh_cmd, rfstep);
        break;
    case 1:
        dy = Fmt (smh_cmd, "%s;RF:VAR %fKHZ", smh_cmd, rfstep);
        break;
    case 2:
        dy = Fmt (smh_cmd, "%s;RF:VAR %fMHZ", smh_cmd, rfstep);
        break;
    case 3:
        dy = Fmt (smh_cmd, "%s;RF:VAR %fGHZ", smh_cmd, rfstep);
        break;
    default:
        smh_err =  -22;
        return;
        break;
    }
    dy = Fmt (smh_cmd, "%s;LEV:VAR %fDB", smh_cmd, rflev);
    if (smh_write_data (dev, smh_cmd) != 0)  
        return;
    if (!smh_do_opc)  
        return;
    smh_op_complete (dev, &dy);
}

/* * */
void smh_set_modulation_step (dev, am, fm, phm)
int dev;
double am;
double fm;
double phm;
{
    int dy;
    
    dy = Fmt (smh_cmd, "PHM:VAR %fRAD;FM:VAR %fKHZ;AM:VAR %fPCT", phm, fm, am);
    if (smh_write_data (dev, smh_cmd) != 0)  
        return;
    if (!smh_do_opc)  
        return;
    smh_op_complete (dev, &dy);
}

/* * */
void smh_single_var_step (dev, fun, stp)
int dev;
int fun;
int stp;
{
    int dy;
    
    switch (stp)  {
    case 0:
        dy = Fmt (smh_cmd, "DEC:");
        break;
    case 1:
        dy = Fmt (smh_cmd, "INC:");
        break;
    default:
        smh_err =  -23;
        return;
        break;
    }
    switch (fun)  {
    case 0:
        dy = Fmt (smh_cmd, "%s<%sAF", smh_cmd);
        break;
    case 1:
        dy = Fmt (smh_cmd, "%s<%sRF", smh_cmd);
        break;
    case 2:
        dy = Fmt (smh_cmd, "%s<%sLEVEL:AF", smh_cmd);
        break;
    case 3:
        dy = Fmt (smh_cmd, "%s<%sLEVEL:RF", smh_cmd);
        break;
    case 4:
        dy = Fmt (smh_cmd, "%s<%sAM", smh_cmd);
        break;
    case 5:
        dy = Fmt (smh_cmd, "%s<%sFM", smh_cmd);
        break;
    case 6:
        dy = Fmt (smh_cmd, "%s<%sPHM", smh_cmd);
        break;
    default:
        smh_err =  -24;
        return;
        break;
    }
    if (smh_write_data (dev, smh_cmd) != 0)  
        return;
    if (!smh_do_opc)  
        return;
    smh_op_complete (dev, &dy);
}

/* * */
void smh_diagnostics (dev, tpoint, test, testvolt)
int dev;
int tpoint;
int test;
double *testvolt;
{
    int dy;
    
    switch (test)  {
    case 0:
        dy = Fmt (smh_cmd, "TEST:OFF");
        dy = smh_write_data (dev, smh_cmd);
        break;
    case 1:
        dy = Fmt (smh_cmd, "TEST:POINT %i;TEST:VOLT?", tpoint);
        if (smh_write_data (dev, smh_cmd) != 0)  
            return;
        if (smh_read_data (dev, smh_cmd) != 0)  
            return;
        dy = Scan (smh_cmd, "%s>%f", testvolt);
        break;
    default:
        smh_err =  -25;
        return;
        break;
    }
    if (!smh_do_opc)  
        return;
    smh_op_complete (dev, &dy);
}

/* * */
void smh_close (dev)
int dev;
{
    int i;
    
    i = smh_get_handle (dev);
    if (i <= 0)  
        return;
    if (ibloc (i) <= 0)  {
        smh_err = 234;
        return;
    }
    if (CloseDev (i) < 0)  
        smh_err = 221;
    else  
        smh_err = 0;
    smh_bd[dev] = 0;
}

/* * */
void smh_driver_version (p0)
double *p0;
{
    
    smh_version = SMH_VER;
    *p0 = smh_version;
}

/* * */
void smh_op_complete (dev, compl)
int dev;
int *compl;
{
    int dy;
    int esr;
    
    *compl = 0;
    while (!*compl)  {
        dy = Fmt (smh_cmd, "*HDR 0; *OPC?");
        if (smh_write_data (dev, smh_cmd) != 0)  
            return;
        if (smh_read_data (dev, smh_cmd) != 0)  
            return;
        dy = Scan (smh_cmd, "%s>%i", compl);
        if (SMH_MONITOR != 0)  
            *compl = 1;
    }
    dy = Fmt (smh_cmd, "*ESR?");
    if (smh_write_data (dev, smh_cmd) != 0)  
        return;
    if (smh_read_data (dev, smh_cmd) != 0)  
        return;
    dy = Scan (smh_cmd, "%s>%i", &esr);
    if ((esr & 16) != 0)  
        smh_err = 300;
}

void smh_set_opc (onoff)
int onoff;
{
    
    if (onoff != 0)  
        smh_do_opc = 1;
    else  
        smh_do_opc = 0;
}

/* * */
int smh_init (dev, addr)
int dev;
int addr;
{
    int dy;
    
    smh_do_opc = 1;
    if (smh_get_handle (dev) > 0)  
        smh_close (dev);
    if (smh_get_handle (dev) < 0)  
        return  -1;
    if (addr < 0 || addr > 30)  {
        smh_err =  -1;
        return  -1;
    }
    if (SMH_MONITOR != 0)  {
        smh_err = 0;
        smh_bd[dev] = dev + 1;
        return 0;
    }
    smh_bd[dev] = OpenDev ("", "smh_");
    if (smh_bd[dev] <= 0)  {
        smh_err = 220;
        smh_bd[dev] = 0;
        return  -1;
    }
    if (ibpad (smh_bd[dev], addr) < 0)  {
        smh_err = 233;
        return  -1;
    }
    if (ibclr (smh_bd[dev]) <= 0)  {
        smh_err = 236;
        return  -1;
    }
    dy = Fmt (smh_cmd, "*RST; *HDR 0");
    if (smh_write_data (dev, smh_cmd) != 0)  
        return  -1;
    smh_err = 0;
    return 0;
}

/* * */
int smh_read_data (dev, cmd)
int dev;
char *cmd;
{
    int dvh;
    
    dvh = smh_get_handle (dev);
    if (dvh <= 0)  
        return smh_err;
    if (SMH_MONITOR != 0)  {
        smh_err = 0;
        dvh = Fmt (cmd, "");
        return 0;
    }
    if (ibrd (dvh, cmd, 255L) <= 0)  
        smh_err = 231;
    else  
        smh_err = 0;
    return smh_err;
}

/* * */
int smh_write_data (dev, cmd)
int dev;
char *cmd;
{
    char loc_cmd[256];
    int dvh;
    int i;
    
    dvh = smh_get_handle (dev);
    if (dvh <= 0)  
        return smh_err;
    if (SMH_MONITOR != 0 || SMH_SHOW_WRITE_DATA != 0)  
        i = FmtOut ("%s\r\n", cmd);
    if (SMH_MONITOR != 0)  
        smh_err = 0;
    else  {
        i = Fmt (loc_cmd, "%s", cmd);
        if (ibwrt (dvh, loc_cmd, (long)NumFmtdBytes ()) <= 0)  
            smh_err = 230;
        else  
            smh_err = 0;
    }
    return smh_err;
}

/* * */
int smh_get_handle (devnr)
int devnr;
{
    
    if (devnr < 0 || devnr > 3)  {
        smh_err = 217;
        return  -1;
    }
    if (smh_bd[devnr] <= 0)  {
        smh_err = 218;
        return 0;
    }
    smh_err = 0;
    return smh_bd[devnr];
}

